/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.BlockCondition;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class ReplaceOperation {
    public static void replace(BlockCondition blockCondition, class_2680 to) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            ReplaceOperation.replaceAABB(aabb, blockCondition, to);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            ReplaceOperation.replaceSet(set, blockCondition, to);
        }
    }

    private static void replaceAABB(SelectionBuffer.AABB aabb, BlockCondition blockCondition, class_2680 to) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int changeCount = 0;
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600() - 1, maxY);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (!blockCondition.matches(block) || block.method_26204() == class_2246.field_10243) continue;
                    setOperation.set(x, y, z, to);
                    previousBlocksForUndo.set(x, y, z, block);
                    ++changeCount;
                }
            }
        }
        if (changeCount == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount);
        String blockName = AxiomI18n.get(to.method_26204().method_9539());
        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, aabb.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Replace Operation"));
    }

    private static void replaceSet(SelectionBuffer.Set set, BlockCondition blockCondition, class_2680 to) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        set.selectionRegion.forEach((x, y, z) -> {
            class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockCondition.matches(block) && block.method_26204() != class_2246.field_10243) {
                setOperation.set(x, y, z, to);
                previousBlocksForUndo.set(x, y, z, block);
                ++changeCount.value;
            }
        });
        if (changeCount.value == 0) {
            return;
        }
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String blockName = AxiomI18n.get(to.method_26204().method_9539());
        String historyDescription = AxiomI18n.get("axiom.history_description.set_n_blocks_to", countString, blockName);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, set.selectionRegion.getCenter(), historyDescription, 0), Dispatcher.simpleSourceInfo("Replace Operation"));
    }
}

